/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.world;

import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.gunsrpg.api.common.IGeneratorConfig;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SimpleOreGenConfig
implements IGeneratorConfig {
    @Configurable
    @Configurable.Range(min=0L, max=128L)
    @Configurable.Comment(value={"Generation attempts per chunk"})
    public int spawns;
    @Configurable
    @Configurable.Range(min=1L, max=255L)
    @Configurable.ValueUpdateCallback(method="onMinHeightValidate")
    @Configurable.Comment(value={"Minimum generation height"})
    public int minHeight;
    @Configurable
    @Configurable.Range(min=1L, max=255L)
    @Configurable.ValueUpdateCallback(method="onMaxHeightValidate")
    @Configurable.Comment(value={"Maximum generation height"})
    public int maxHeight;

    public SimpleOreGenConfig(int spawnAttempts, int minGenHeight, int maxGenHeight) {
        this.spawns = spawnAttempts;
        this.minHeight = minGenHeight;
        this.maxHeight = maxGenHeight;
    }

    @Override
    public int getSpawnAttempts() {
        return this.spawns;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void onMinHeightValidate(int value, IValidationHandler handler) {
        if (value >= this.maxHeight) {
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.ore_gen.min_height", new Object[]{value, this.maxHeight})));
        }
    }

    public void onMaxHeightValidate(int value, IValidationHandler handler) {
        if (value <= this.minHeight) {
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.ore_gen.max_height", new Object[]{value, this.minHeight})));
        }
    }
}

